﻿using System;
using System.IO;
using System.Text;
using gov.va.med.VBECS.Communication.Common;

namespace gov.va.med.VBECS.Communication.Utils
{
    public class TextMessageSerializer : IMessageSerializer
    {
        readonly string _path = Path.GetDirectoryName(typeof(BinaryMessageSerializer).Assembly.Location);

        public void SerializeObject(string filename, IMessage objectToSerialize)
        {
            if (filename == null)
                throw new ArgumentException("File name is null");
            if (!(objectToSerialize is RawDataMessage))
                throw new ArgumentException("Object is not RawDataMessage");

            filename = Path.Combine(_path, filename.Replace('-', '_'));
            // *** Fortify Justified Code ***
            // *** All portablility issues are justified as our environment is only Windows and it is is stricly controlled. ***
            Directory.CreateDirectory(Path.GetDirectoryName(filename) ?? "");
            Stream stream = File.Open(filename, FileMode.Create);
            // *** Fortify Justified Code *** 

            using (var writer = new StreamWriter(stream))
            {
                writer.Write( Encoding.UTF8.GetString(((RawDataMessage)objectToSerialize).Data));
            }

            stream.Close();
        }

        public IMessage DeSerializeObject(string filename)
        {
            filename = Path.Combine(_path, filename.Replace('-', '_'));
            Stream stream = File.Open(filename, FileMode.Open);

            IMessage m;
            using (var reader = new StreamReader(stream))
            {
                m = new RawDataMessage(Encoding.UTF8.GetBytes(reader.ReadToEnd()));
            }
            stream.Close();
            return m;
        }
    }
}